# Testes Automatizados - Publicação Estatísticas

Este documento descreve os testes automatizados implementados para a funcionalidade de estatísticas de publicações.

## 📋 Estrutura de Testes

### 1. **Testes Unitários** (`tests/Unit/PublicacaoEstatisticasTest.php`)

Validam a lógica individual dos métodos:

- ✅ `test_estatisticas_loads_auditoria_splash_data()` - Carregamento de dados
- ✅ `test_total_usuarios_unicos_is_calculated_correctly()` - Cálculo de usuários únicos
- ✅ `test_top_hotspots_are_sorted_by_impressions()` - Ordenação de hotspots
- ✅ `test_impressoes_por_dia_calculated_correctly()` - Cálculo de dados por dia
- ✅ `test_mac_address_formatting()` - Formatação de MAC address
- ✅ `test_ctr_is_always_100_percent_for_splash()` - Cálculo correto de CTR

**Executar:**
```bash
php artisan test tests/Unit/PublicacaoEstatisticasTest.php
```

### 2. **Testes Feature** (`tests/Feature/PublicacaoEstatisticasFeatureTest.php`)

Validam a integração entre componentes e o fluxo completo:

- ✅ `test_estatisticas_page_loads_successfully()` - Página carrega com sucesso
- ✅ `test_top_10_hotspots_section_displays()` - Seção de hotspots exibe
- ✅ `test_daily_data_section_displays()` - Seção de dados por dia exibe
- ✅ `test_users_who_viewed_section_displays()` - Seção de usuários exibe
- ✅ `test_general_statistics_are_correct()` - Estatísticas gerais corretas
- ✅ `test_estatisticas_returns_404_for_nonexistent_publicacao()` - Retorna 404 para publicação inexistente
- ✅ `test_unauthenticated_user_is_redirected()` - Usuário não autenticado é redirecionado
- ✅ `test_clicks_per_hour_are_calculated()` - Cliques por hora calculados

**Executar:**
```bash
php artisan test tests/Feature/PublicacaoEstatisticasFeatureTest.php
```

### 3. **Testes E2E com Dusk** (`tests/Browser/PublicacaoEstatisticasTest.php`)

Validam a experiência do usuário em um navegador real:

- ✅ `test_estatisticas_page_loads_and_displays_data()` - Página carrega e exibe dados
- ✅ `test_general_statistics_cards_display_data()` - Cards de estatísticas exibem
- ✅ `test_hotspots_table_displays_data()` - Tabela de hotspots exibe
- ✅ `test_users_table_displays_correctly_formatted_data()` - Tabela de usuários exibe
- ✅ `test_breadcrumb_navigation_works()` - Navegação por breadcrumb funciona
- ✅ `test_back_button_navigation()` - Botão voltar funciona
- ✅ `test_edit_button_navigation()` - Botão editar funciona
- ✅ `test_publication_info_card_displays_correct_data()` - Card de informações exibe dados corretos
- ✅ `test_unauthenticated_user_redirects_to_login()` - Usuário não autenticado é redirecionado
- ✅ `test_mac_address_is_formatted_for_privacy()` - MAC address é formatado para privacidade
- ✅ `test_dates_are_formatted_correctly()` - Datas formatadas corretamente
- ✅ `test_page_is_responsive_on_mobile()` - Página é responsiva em mobile
- ✅ `test_daily_data_chart_is_present()` - Gráfico de dados por dia está presente

**Executar:**
```bash
php artisan dusk tests/Browser/PublicacaoEstatisticasTest.php
```

## 🚀 Executar Todos os Testes

### Opção 1: Script Shell
```bash
chmod +x run-tests.sh
./run-tests.sh
```

### Opção 2: Comandos Individuais

```bash
# Testes Unitários
php artisan test tests/Unit/PublicacaoEstatisticasTest.php

# Testes Feature
php artisan test tests/Feature/PublicacaoEstatisticasFeatureTest.php

# Testes E2E (Dusk)
php artisan dusk tests/Browser/PublicacaoEstatisticasTest.php

# Todos os testes
php artisan test

# Com coverage report
php artisan test --coverage
```

## 📊 Gerar Coverage Report

```bash
# HTML Report
php artisan test --coverage --coverage-html=tests/coverage

# Terminal Report
php artisan test --coverage --coverage-text
```

## 🔧 Configuração do Dusk

### Pré-requisitos
1. **ChromeDriver** instalado
2. **Chrome/Chromium** instalado
3. Variável de ambiente `.env.dusk.local` configurada

### Setup do Dusk

```bash
# Instalar Dusk
composer require --dev laravel/dusk

# Publicar assets
php artisan dusk:install

# Gerar ChromeDriver
php artisan dusk:chrome-driver
```

### Arquivo `.env.dusk.local`
```env
APP_URL=http://localhost:8000
DB_DATABASE=adm_freefi_test
DB_CONNECTION=mysql
```

## 📝 Padrões de Teste

### Nomenclatura
- **Unitários**: `test_what_should_happen_when_condition_met()`
- **Feature**: `test_user_can_access_page()` ou `test_feature_displays_data()`
- **E2E**: `test_complete_flow_or_user_interaction()`

### Estrutura
```php
public function test_something()
{
    // Arrange: Preparar dados
    $publicacao = Publicacao::factory()->create();
    
    // Act: Executar ação
    $response = $this->get(route('publicacoes.estatisticas', $publicacao));
    
    // Assert: Verificar resultado
    $response->assertStatus(200);
}
```

## 🎯 Cobertura Esperada

- **Controlador**: ~95% (métodos principais cobertos)
- **Modelo**: ~90% (relacionamentos e scopes)
- **Views**: Validadas via Dusk E2E
- **Helpers**: 100% (métodos utilitários)

## 🐛 Troubleshooting

### Erro: "Chrome failed to start"
```bash
# Reinstalar ChromeDriver
php artisan dusk:chrome-driver --detect
```

### Erro: "Database connection failed"
```bash
# Certifique-se que `.env.dusk.local` existe e tem credenciais corretas
cp .env.example .env.dusk.local
# Edite com credenciais de teste
```

### Erro: "SQLSTATE[HY000]"
```bash
# Criar banco de dados de teste
mysql -u root -p -e "CREATE DATABASE adm_freefi_test;"
```

## 📈 Próximos Passos

1. Integrar testes no CI/CD (GitHub Actions, GitLab CI)
2. Adicionar testes de performance
3. Aumentar cobertura para 100%
4. Implementar tests de segurança (CSRF, XSS)

## 📚 Referências

- [Laravel Testing Documentation](https://laravel.com/docs/testing)
- [Laravel Dusk Documentation](https://laravel.com/docs/dusk)
- [Pest PHP](https://pestphp.com/) - Alternativa a PHPUnit

---

**Última atualização:** 03/11/2025
**Versão Laravel:** 12.34.0
**Versão PHP:** 8.3.26
