import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import path from 'path';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js', 'public/assets/scss/style.scss'],
            refresh: true,
        }),
    ],
    resolve: {
        alias: {
            '@scss': path.resolve(__dirname, 'public/assets/scss/app'),
        },
    }
});